<?php 
    // We include db_connect.php to prevent errors if other parts of the site need it, 
    // but this page will work even if the DB is empty.
    include 'db_connect.php'; 
    include 'header.php'; 
?>

<section class="page-hero" style="height: 40vh; background: linear-gradient(rgba(102, 0, 0, 0.6), rgba(102, 0, 0, 0.6)), url('images/judge-s-gavel-table-court-room-closeup-concept-justice-law-generative-ai.jpg') no-repeat center center/cover;">
    <div class="container">
        <h1>Past Judges</h1>
        <p>Honoring the distinguished service of former Justices of the Civil Appellate High Court.</p>
    </div>
</section>

<section class="content-section reveal" style="padding: 80px 8%; background: #fff;">
    
    <div class="section-header" style="margin-bottom: 50px; text-align: center;">
        <p class="sub-title" style="color:var(--gold-accent); text-transform:uppercase; letter-spacing:2px; font-size:0.9rem;">Archive</p>
        <h2 style="color:var(--primary-color); font-size:2.2rem;">Past Judges of the <span style="font-family:'Playfair Display', serif; color:var(--gold-accent); font-style:italic;">Civil Appellate Court</span></h2>
        <div class="gold-divider" style="width:60px; height:4px; background-color:var(--gold-accent); margin: 15px auto;"></div>
    </div>

    <div class="past-judges-container" style="max-width: 1000px; margin: 0 auto; background: white; padding: 40px; border-radius: 8px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); border-top: 4px solid var(--primary-color);">
        
        <ul style="column-count: 2; column-gap: 60px; list-style: none;">
            <li style="margin-bottom: 15px; font-size: 1.05rem; color: #444; border-bottom: 1px solid #eee; padding-bottom: 5px;">
                <i class="fas fa-gavel" style="color: var(--gold-accent); margin-right: 10px; font-size: 0.8rem;"></i> 
                Hon. Justice G. Thissera
            </li>
            <li style="margin-bottom: 15px; font-size: 1.05rem; color: #444; border-bottom: 1px solid #eee; padding-bottom: 5px;">
                <i class="fas fa-gavel" style="color: var(--gold-accent); margin-right: 10px; font-size: 0.8rem;"></i> 
                Hon. Justice A.K.C. Ranasinghe
            </li>
            <li style="margin-bottom: 15px; font-size: 1.05rem; color: #444; border-bottom: 1px solid #eee; padding-bottom: 5px;">
                <i class="fas fa-gavel" style="color: var(--gold-accent); margin-right: 10px; font-size: 0.8rem;"></i> 
                Hon. Justice J.F.A. Soza
            </li>
            <li style="margin-bottom: 15px; font-size: 1.05rem; color: #444; border-bottom: 1px solid #eee; padding-bottom: 5px;">
                <i class="fas fa-gavel" style="color: var(--gold-accent); margin-right: 10px; font-size: 0.8rem;"></i> 
                Hon. Justice H.A.G. De Silva
            </li>
            <li style="margin-bottom: 15px; font-size: 1.05rem; color: #444; border-bottom: 1px solid #eee; padding-bottom: 5px;">
                <i class="fas fa-gavel" style="color: var(--gold-accent); margin-right: 10px; font-size: 0.8rem;"></i> 
                Hon. Justice B.E. De Silva
            </li>
            <li style="margin-bottom: 15px; font-size: 1.05rem; color: #444; border-bottom: 1px solid #eee; padding-bottom: 5px;">
                <i class="fas fa-gavel" style="color: var(--gold-accent); margin-right: 10px; font-size: 0.8rem;"></i> 
                Hon. Justice S.B. Goonewardene
            </li>
            <li style="margin-bottom: 15px; font-size: 1.05rem; color: #444; border-bottom: 1px solid #eee; padding-bottom: 5px;">
                <i class="fas fa-gavel" style="color: var(--gold-accent); margin-right: 10px; font-size: 0.8rem;"></i> 
                Hon. Justice P.R.P. Perera
            </li>
            <li style="margin-bottom: 15px; font-size: 1.05rem; color: #444; border-bottom: 1px solid #eee; padding-bottom: 5px;">
                <i class="fas fa-gavel" style="color: var(--gold-accent); margin-right: 10px; font-size: 0.8rem;"></i> 
                Hon. Justice A.S. Wijetunga
            </li>
            <li style="margin-bottom: 15px; font-size: 1.05rem; color: #444; border-bottom: 1px solid #eee; padding-bottom: 5px;">
                <i class="fas fa-gavel" style="color: var(--gold-accent); margin-right: 10px; font-size: 0.8rem;"></i> 
                Hon. Justice T.B. Weerasuriya
            </li>
            <li style="margin-bottom: 15px; font-size: 1.05rem; color: #444; border-bottom: 1px solid #eee; padding-bottom: 5px;">
                <i class="fas fa-gavel" style="color: var(--gold-accent); margin-right: 10px; font-size: 0.8rem;"></i> 
                Hon. Justice N.E. Dissanayake
            </li>
            <li style="margin-bottom: 15px; font-size: 1.05rem; color: #444; border-bottom: 1px solid #eee; padding-bottom: 5px;">
                <i class="fas fa-gavel" style="color: var(--gold-accent); margin-right: 10px; font-size: 0.8rem;"></i> 
                Hon. Justice A. de Z. Gunawardana
            </li>
            <li style="margin-bottom: 15px; font-size: 1.05rem; color: #444; border-bottom: 1px solid #eee; padding-bottom: 5px;">
                <i class="fas fa-gavel" style="color: var(--gold-accent); margin-right: 10px; font-size: 0.8rem;"></i> 
                Hon. Justice H.S. Yapa
            </li>
             <li style="margin-bottom: 15px; font-size: 1.05rem; color: #444; border-bottom: 1px solid #eee; padding-bottom: 5px;">
                <i class="fas fa-gavel" style="color: var(--gold-accent); margin-right: 10px; font-size: 0.8rem;"></i> 
                Hon. Justice P.H.K. Kulatilaka
            </li>
             <li style="margin-bottom: 15px; font-size: 1.05rem; color: #444; border-bottom: 1px solid #eee; padding-bottom: 5px;">
                <i class="fas fa-gavel" style="color: var(--gold-accent); margin-right: 10px; font-size: 0.8rem;"></i> 
                Hon. Justice A.A.R. Heiyanthuduwa
            </li>
        </ul>
        
        <p style="text-align: center; margin-top: 30px; color: #666; font-style: italic; font-size: 0.9rem;">
            * This archive includes Justices who have served in the Civil Appellate jurisdiction since its inception under Act No. 54 of 2006.
        </p>
    </div>

</section>

<script>
    // Reveal Animation
    window.addEventListener('scroll', function() {
        var reveals = document.querySelectorAll('.reveal');
        for(var i = 0; i < reveals.length; i++){
            var windowheight = window.innerHeight;
            var revealtop = reveals[i].getBoundingClientRect().top;
            var revealpoint = 150;
            if(revealtop < windowheight - revealpoint){
                reveals[i].classList.add('active');
            }
        }
    });
</script>

<?php include 'footer.php'; ?>